<?php
/**
 * @package Joomla
 * @subpackage Carlhenry Global for Joomla 3+
 * @copyright (C) 2022 FA Software
 * @license GNU/GPLv3
 */

// no direct access

defined('_JEXEC') or die('Restricted access');

$langSite = substr($params->get('api_key'), 0, 2);
$width = 'width:' . trim($params->get('width', '80%')) . ';';

if ($langSite != '')
{
	$langSite .= '/';
}

// prepares the introductory text
$introtext = '';

if ($params->get('show_text', 1))
{
	$introtext = '<p>'.trim($params->get('intro_text', '')).'</p>'."\n";
}

echo "\n";

// Prepare the amount field / currency combobox or hide it
$class = $params->get('css_class', '');
$amountLine = '';

if (!$params->get('show_amount'))
{
	$amountLine .= '<input type="hidden" name="amount" value="'.$params->get('amount').'" />'."\n";
}
else
{
	$amountLine .= JText::_('Amount').':&nbsp;<input type="text" name="amount" size="4" maxlength="10" value="'.$params->get('amount').'" style="text-align:right;' . $width . '" class="' . $class . '" />'."\n";
}

// Get the list of currencies from the parameters and explode them into an array
$currencies = explode(',', $params->get('currencies'));

// Array lists the available PayPal Currencies as of 03/Jan/2009
$availableCurrencies = Array('EUR', 'USD', 'GBP', 'CHF', 'AUD', 'HKD', 'CAD', 'JPY', 'NZD', 'SGD', 'SEK', 'DKK', 'PLN', 'NOK', 'HUF', 'CZK', 'ILS', 'MXN');

// checks currency list against the available currencies list and discards errors.
$sizeOfCurr = sizeof($currencies);
for ($i = 0; $i < $sizeOfCurr; $i++)
{
	for ($j = 0; $j < sizeof($availableCurrencies); $j++)
	{
		if ($currencies[$i] === $availableCurrencies[$j])
		{
			$isOk = 1;
			break;
		}
	}
	
	if (!$isOk)
	{
		unset($currencies[$i]);
	}
	$isOk = 0;
}

// Choose between a combo-box or a simple hidden text field based on size of the array
if (sizeof($currencies) == 0)
{
	$amountLine = '<p class="error">'.JText::_('MOD_SIMPLEPAYPAL_ERROR_NO_CURRENCIES_SELECTED').'!<br/>'.JText::_('SIMPLEPAYPAL_PLEASE_CHECK_THE_BACKEND_PARAMETERS').'</p>';
	$fe_c = '';
}
else if (sizeof($currencies) == 1)
{
	echo $introtext;
	$fe_c = '<input type="hidden" name="currency_code" value="' . $currencies[0] . '" />'."\n";
	if ($params->get('show_amount', 1))
	{
		$fe_c .= '&nbsp;' . $currencies[0]."\n";
	}
} else if (sizeof($currencies) > 1)
{
	echo $introtext;
	if ($params->get('show_amount', 1))
	{
		$fe_c = '<select name="currency_code" class="' . $class . '" style="width:75px">'."\n";
		foreach($currencies as $row)
		{
			$fe_c .= '<option value="'.$row.'">'.$row.'</option>'."\n";
		}
		$fe_c .= '</select>'."\n";
	}
	else
	{
		$fe_c = '<input type="hidden" name="currency_code" value="' . $currencies[0] . '" />'."\n";
	}
}

$target = '';
if ($params->get('open_new_window', 1))
{
	$target =  'target="paypal"';
}

// Info:
// Button images: http://www.rocketgranny.com/codeclips/pp_button_images.php

if( isset($_POST['amount']) ){
    $total_amount =  $_POST['amount'] * 1098901.098901099;

    $user = JFactory::getUser();
    $email;
    if ($user->id == 0) {

       $email = 'test@test.com';

    }else{

       $email = $user->email;

    }

    
	
	$vars = [
	            'amount' => (int)$total_amount,
	            'paymentRequestExpirationTime' => (int)$_POST['expiration_time'], 
	            'receiptEmail' => $email,
	            'description'=>JURI::base(),
	            //'returnUrl'=>"http://localhost/ada_new/index.php?option=com_virtuemart&view=vmplg&task=PaymentResponseReceived&on=SIYC05&pm=2&Itemid=0&lang="
	            'returnUrl'=> JURI::base(),

            ];


              $curl = curl_init();
	          curl_setopt_array($curl, [
	          CURLOPT_URL =>  $_POST['url']."/"."payment-request",
	          CURLOPT_RETURNTRANSFER => true,
	          CURLOPT_ENCODING => "",
	          CURLOPT_MAXREDIRS => 10,
	          CURLOPT_TIMEOUT => 30,
	          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	          CURLOPT_CUSTOMREQUEST => "PUT",
	          CURLOPT_POSTFIELDS => json_encode($vars),
	          // CURLOPT_POSTFIELDS => "{\"parameters\":[{\"name\":\"name\",\"value\":\"$name\"},{\"name\":\"phone\",\"value\":\"$phone\"}],\"template_name\":\"$template_name\",\"broadcast_name\":\"$broadcast_name\"}",
	          CURLOPT_HTTPHEADER => [
	            "Authorization: Bearer ".$_POST['api_key'],
	           "Content-Type: application/json"
	          ],
	        ]);

	        $response = curl_exec($curl);
	        $data = json_decode($response);

	 
	        $session = JFactory::getSession();
            $session->set('uuid',$data->uuid);

	        if (isset($data)) {
	        
	            if ($data->statusCode  == 400) {

	            	$html =  "<h3> An error occurred while placing order! Error info: " . $data->message[0].  "</h3>";

	            	$mainframe = JFactory::getApplication ();
	                $mainframe->enqueueMessage ($html);

	                return $mainframe->redirect (JURI::base());


	            }else if ($data->statusCode  == 401) {

	            	$html =  "<h3>Please Check your API KEY AND URL  " . $data->message.  "</h3>";

	            	$mainframe = JFactory::getApplication ();
	                $mainframe->enqueueMessage ($html);

	                return $mainframe->redirect (JURI::base());
	            	

	            } else {


	            	if ($params->get('sandbox') == 1) {
	            		
		                header( 'Location: ' . 'https://sandbox.adapay.finance/pay/'.$data->uuid );
		                exit;
	            	}else{
	            		
	            		header( 'Location: ' . 'https://adapay.finance/pay/'.$data->uuid );
		                exit;

	            	}
	               
	            }
            }else{

            	$html =  "<h3> Please the ADA PAY Url from an Administrator </h3>";

	            	$mainframe = JFactory::getApplication ();
	                $mainframe->enqueueMessage ($html);

	                return $mainframe->redirect (JURI::base());


            }


}


?>


 <form action="." method="post">
 	
	<input type="hidden"  name="amount" value="<?php echo$params->get('amount', ''); ?>" />
    <?php echo $amountLine?>
	<input type="hidden" name="expiration_time" value="<?php echo$params->get('expiration_time', ''); ?>" />
	<input type="hidden" name="return" value="<?php echo$params->get('return', ''); ?>" />
	<input type="hidden"  name="api_key" value="<?php echo$params->get('api_key', ''); ?>" />
	<input type="hidden"  name="url" value="<?php echo$params->get('url', ''); ?>" />
	<br />
	<?php if ($fe_c != '') : ?>
	<div align="center">
		<input 
			type="image"
			src="https://sandbox.adapay.finance/images/<?php echo $params->get('pp_image'); ?>"
			name="submit" alt="ADA secure  PAYMENT." id="adapay"
		/>
	</div>
	<?php endif; ?>

</form>

