<?php
/*
* A payment plugin called "adapayments". This is the main file of the plugin.
*/

// You need to extend from the hikashopPaymentPlugin class which already define lots of functions in order to simplify your work
class plgHikashoppaymentAdapayments extends hikashopPaymentPlugin
{
	var $accepted_currencies = array(); //List of the plugin's accepted currencies. The plugin won't appear on the checkout if the current currency is not in that list. You can remove that attribute if you want your payment plugin to display for all the currencies
	var $multiple = true; // Multiple plugin configurations. It should usually be set to true
	var $name = 'adapayments'; //Payment plugin name (the name of the PHP file)
	
	var $cancel_url;
	var $success_url;
	var $ipn_url;

	// This array contains the specific configuration needed (Back end > payment plugin edition), depending of the plugin requirements.
	// They will vary based on your needs for the integration with your payment gateway.
	// The first parameter is the name of the field. In upper case for a translation key.
	// The available types (second parameter) are: input (an input field), html (when you want to display some custom HTML to the shop owner), textarea (when you want the shop owner to write a bit more than in an input field), big-textarea (when you want the shop owner to write a lot more than in an input field), boolean (for a yes/no choice), checkbox (for checkbox selection), list (for dropdown selection) , orderstatus (to be able to select between the available order statuses)
	// The third parameter is the default value.
	var $pluginConfig = array(

		'sandbox' => array("Enable Sandbox",'boolean','0'),

		'api_key' => array("ADA PAY API KEY",'input'),

		'url' => array("ADA PAY UrL",'input'),

		'expiration_time' =>  array("Payment Expiration Time (in Minutes)",'input'),
		//'ipn_secret' => array("IPN Secret",'input'), //User's password on the payment platform
		'debug_email' => array('Debug Email (optional, recommended while testing)', 'input'), //Write some things on the debug file
		'invalid_status' => array('INVALID_STATUS', 'orderstatus'), //Invalid status for order in case of problem during the payment process
		'verified_status' => array('VERIFIED_STATUS', 'orderstatus'), //Valid status for order if the payment has been done well
		'collect_shipping' => array('Send shipping info to AdaPayments', 'boolean', '1'),
		'allow_zero_confirm' => array('Enable zero-confirmation payments (recommended for digital downloads only)', 'boolean', '0'),
	);

	// The constructor is optional if you don't need to initialize some parameters of some fields of the configuration and not that it can also be done in the getPaymentDefaultValues function as you will see later on
	function __construct(&$subject, $config)
	{
		$this->cancel_url = HIKASHOP_LIVE."index.php?option=com_hikashop&ctrl=order&task=cancel_order";
		//$this->success_url = HIKASHOP_LIVE."index.php?option=com_hikashop&ctrl=checkout&task=after_end";
		//$this->success_url = HIKASHOP_LIVE."index.php?option=com_hikashop&ctrl=checkout&task=success_after_end";

		$this->ipn_url = HIKASHOP_LIVE.'index.php?option=com_hikashop&ctrl=checkout&task=notify&amp;notif_payment=adapayments&tmpl=component';
		return parent::__construct($subject, $config);
	}

	// public function onBeforeOrderCreate(&$order,&$do){


	// 	if(parent::onBeforeOrderCreate($order, $do) === true)
	// 		return true;

	// 	if((empty($this->payment_params->url) || empty($this->payment_params->api_key) || empty($this->payment_params->expiration_time))) {
	// 		$this->app->enqueueMessage('Please check your &quot;ADA PAY&quot; plugin configuration');
	// 		$do = false;
	// 	}
	// }


	//This function is called at the end of the checkout. That's the function which should display your payment gateway redirection form with the data from HikaShop
	function onAfterOrderConfirm(&$order,&$methods,$method_id)
	{


		parent::onAfterOrderConfirm($order,$methods,$method_id); // This is a mandatory line in order to initialize the attributes of the payment method

		//Here we can do some checks on the options of the payment method and make sure that every required parameter is set and otherwise display an error message to the user
		if (empty($this->payment_params->api_key)) //The plugin can only work if those parameters are configured on the website's backend
		{
		
			$this->app->enqueueMessage('Please check your ADA PAY API KEY  parameter on your Administrator Site','error');
			       
	        return $this->app->redirect (JRoute::_ ('index.php?option=com_hikashop&ctrl=checkout',FALSE));
			//Enqueued messages will appear to the user, as Joomla's error messages
			//return false;
		}else if (empty($this->payment_params->url)) {

			$this->app->enqueueMessage('Please check your ADA PAY URL parameter on your Administrator Site','error');
			       
	        return $this->app->redirect (JRoute::_ ('index.php?option=com_hikashop&ctrl=checkout',FALSE));
			
		}else if (empty($this->payment_params->expiration_time)) {

			$this->app->enqueueMessage('Please check your ADA PAY Expiration Time parameter on your Administrator Site','error');
			       
	        return $this->app->redirect (JRoute::_ ('index.php?option=com_hikashop&ctrl=checkout',FALSE));
			
		}
		else
		{

			//$this->success_url = HIKASHOP_LIVE.'index.php?option=com_hikashop&ctrl=checkout&task=after_end&order_id='.$order->order_id . $this->url_itemid;

			$this->success_url =  HIKASHOP_LIVE.'index.php?option=com_hikashop&ctrl=checkout&task=notify&notif_payment='.$this->name.'&tmpl=component&lang='.$this->locale . $this->url_itemid;

			// http://localhost/adaFresh/index.php?option=com_hikashop&ctrl=checkout&task=notify&amp;notif_payment=12345&tmpl=component

			// Patch - JT 07/18/19 Updated vars fields item_name, amountf, email(DEP)
			// $vars = array(
			// 	'cmd' => '_pay',
			// 	'reset' => 1,
			// 	'merchant' => $this->payment_params->merchant_id,
			// 	'item_name' => "Order ID".$order->order_number,
			// 	'custom' => $order->order_id,
			// 	'amountf' => round($order->cart->full_total->prices[0]->price_value_with_tax, 8),
			// 	'currency' => $this->currency->currency_code,
			// 	'success_url' => $this->success_url,
			// 	'cancel_url' => $this->cancel_url,
			// 	'ipn_url' => $this->ipn_url,
			// 	'first_name' => $order->cart->shipping_address->address_firstname,
			// 	'last_name' => $order->cart->shipping_address->address_lastname,
			// );

			$total_amount = $order->cart->full_total->prices[0]->price_value_with_tax * 1098901.098901099;

			$vars = [
	            'amount' => (int)$total_amount,
	            'paymentRequestExpirationTime' => (int)$this->payment_params->expiration_time, 
	            'receiptEmail' => $order->customer->user_email,
	            //'returnUrl'=>"http://localhost/ada_new/index.php?option=com_virtuemart&view=vmplg&task=PaymentResponseReceived&on=SIYC05&pm=2&Itemid=0&lang="
	            'returnUrl'=> $this->success_url,

            ];

           
	          $curl = curl_init();
	          curl_setopt_array($curl, [
	          CURLOPT_URL => $this->payment_params->url.'/'.'payment-request',
	          CURLOPT_RETURNTRANSFER => true,
	          CURLOPT_ENCODING => "",
	          CURLOPT_MAXREDIRS => 10,
	          CURLOPT_TIMEOUT => 30,
	          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	          CURLOPT_CUSTOMREQUEST => "PUT",
	          CURLOPT_POSTFIELDS => json_encode($vars),
	          // CURLOPT_POSTFIELDS => "{\"parameters\":[{\"name\":\"name\",\"value\":\"$name\"},{\"name\":\"phone\",\"value\":\"$phone\"}],\"template_name\":\"$template_name\",\"broadcast_name\":\"$broadcast_name\"}",
	          CURLOPT_HTTPHEADER => [
	            "Authorization: Bearer ".$this->payment_params->api_key,
	           "Content-Type: application/json"
	          ],
	        ]);

	        $response = curl_exec($curl);
	        $data = json_decode($response);

	        $session = JFactory::getSession();
	        $session->set('uuid',$data->uuid);
	        $session->set('order_id',$order->order_id);
	        $session->set('api_key',$this->payment_params->api_key);
		    $session->set('url',$this->payment_params->url);

	        //$this->uuid = $data->uuid;
	        if (isset($data)) {
	        
	            if ($data->statusCode  == 400) {

	            	$this->html =  "<h3> An error occurred while placing order! Error info: " . $data->message[0].  "</h3>";
	            	$mainframe = JFactory::getApplication ();
	                $mainframe->enqueueMessage ($this->html);

	                return $mainframe->redirect (JRoute::_ ('index.php?option=com_hikashop&ctrl=checkout',FALSE));

	            }else if ($data->statusCode == 401) {

	            	$this->html =  "<h3>Please check your ADA PAY API KEY and URL from an Administrator </h3><h5>" . $data->message.  "</h5>";
	            	$mainframe = JFactory::getApplication ();
	                $mainframe->enqueueMessage ($this->html);

	                return $mainframe->redirect (JRoute::_ ('index.php?option=com_hikashop&ctrl=checkout',FALSE));

	            	
	            } else {
	                
	            	if ($this->payment_params->sandbox == 1) {
		                header( 'Location: ' . 'https://sandbox.adapay.finance/pay/'.$data->uuid );
		                exit;
	            	}else{
	            		header( 'Location: ' . 'https://adapay.finance/pay/'.$data->uuid );
		                exit;
	            	}
	            }
            }else{

            	    $this->html =  "<h3> Please check your ADA PAY URL and API KEY from an Administrator site </h3>";
	            	$mainframe = JFactory::getApplication ();
	                $mainframe->enqueueMessage ($this->html);

	                return $mainframe->redirect (JRoute::_ ('index.php?option=com_hikashop&ctrl=checkout',FALSE));

            }


            // echo "<pre>";
            // print_r('k');
            // die;
			// if ($this->payment_params->collect_shipping == "1") {
			// 	$vars = array_merge($vars, array(
            //   'address1' => $order->cart->shipping_address->address_street,
			// 		'address2' => $order->cart->shipping_address->address_street2,
			// 		'city' => $order->cart->shipping_address->address_city,
			// 		'state' => $order->cart->shipping_address->address_state->zone_code_3,
			// 		'zip' => $order->cart->shipping_address->address_post_code,
			// 		'country' => $order->cart->shipping_address->address_country->zone_code_3,
			// 		'phone' => $order->cart->shipping_address->address_telephone,
			// 	));
			// }

			// echo "<pre>";
			// print_r($vars);
			// die;

			//Hash generated to certify the values integrity
			//This hash is generated according to the plateform requirements
			//$this->vars = $vars;

			//Ending the checkout, ready to be redirect to the plateform payment final form
			//The showPage function will call the adapayments_end.php file which will display the redirection form containing all the parameters for the payment platform
			
		}
	}


	public function onPaymentConfigurationSave(&$element) {

		// if(!empty($element->payment_params->url))
		// 	$element->payment_params->url = explode(',', $element->payment_params->url);

		if(strpos($element->payment_params->url,'https://')===false){
			$app = JFactory::getApplication();
			$app->enqueueMessage('The URL must start with https://');
			return false;
		}else{

			if (empty($element->payment_params->api_key)) {
			$app = JFactory::getApplication();
			$app->enqueueMessage('Please Enter API KEY');
			return false;
		    }else if (empty($element->payment_params->expiration_time)) {
		    	$app = JFactory::getApplication();
			    $app->enqueueMessage('Please Expiration Time');
			    return false;
		    }
		} 

		return true;
	}



	//To set the specific configuration (back end) default values (see $pluginConfig array)
	function getPaymentDefaultValues(&$element)
	{
	
		$element->payment_name='AdaPayments';
		$element->payment_description='You can pay by Bitcoin or other cryptocurrencies via AdaPayments';
		$element->payment_images='AdaPayments';
		$element->payment_params->collect_shipping=1;
		$element->payment_params->address_type="shipping";
		$element->payment_params->notification=1;
		$element->payment_params->invalid_status='cancelled';
		$element->payment_params->verified_status='confirmed';
	}
	
	function errorAndDie($error_msg) {
		if (!empty($this->payment_params->debug_email)) {
			$report = "Error Message: ".$error_msg."\n\n";
			$report .= "POST Fields\n\n";
			foreach ($_POST as $key => $value) {
				$report .= $key.'='.$value."\n";
			}
			
			$report .= "\nAUTH User Passed: |".$_SERVER['PHP_AUTH_USER']."|\n";
			$report .= "AUTH User Expected: |".trim($this->merchant_id)."|\n\n";
			$report .= "AUTH Pass Passed: |".$_SERVER['PHP_AUTH_PW']."|\n\n";
			$report .= "AUTH Pass Expected: |".trim($this->ipn_secret)."|\n\n";			
			
			mail($this->payment_params->debug_email, "Invalid credentials", $report);
		}
		die('IPN Error: '.$error_msg);
	}
		
	function authorize_adapayments_ipn($posted) {
		
		$error_msg = "Unknown error";
		
		var_dump($this->payment_params);
		var_dump($posted);
		
		if (isset($posted['ipn_mode']) && $posted['ipn_mode'] == 'hmac') {
			if (isset($_SERVER['HTTP_HMAC']) && !empty($_SERVER['HTTP_HMAC'])) {
				$request = file_get_contents('php://input');
				if ($request !== FALSE && !empty($request)) {
					if (isset($posted['merchant']) && $posted['merchant'] == trim($this->payment_params->merchant_id)) {
						$hmac = hash_hmac("sha512", $request, trim($this->payment_params->ipn_secret));
						if ($hmac == $_SERVER['HTTP_HMAC']) {
							return true;
						} else {
							$error_msg = 'HMAC signature does not match';
						}
					} else {
						$error_msg = 'No or incorrect Merchant ID passed';
					}
				} else {
					$error_msg = 'Error reading POST data';
				}
			} else {
				$error_msg = 'No HMAC signature sent.';
			}
		} else {
			if (isset($_SERVER['PHP_AUTH_USER']) && isset($_SERVER['PHP_AUTH_PW']) && $_SERVER['PHP_AUTH_USER'] == trim($this->payment_params->merchant_id) && $_SERVER['PHP_AUTH_PW'] == trim($this->payment_params->ipn_secret)) {
				return true;
			} else {
				$error_msg = "Invalid merchant id/ipn secret";
			}
		}
		$this->errorAndDie($error_msg);
	}

	//After submiting the plateform payment form, this is where the website will receive the response information from the payment gateway servers and then validate or not the order
	function onPaymentNotification(&$statuses)
	{

	   try{

		   	//We first create a filtered array from the parameters received
	        $session = JFactory::getSession();
			$uuid  = $session->get('uuid');
			$api_key  = $session->get('api_key');
			$url  = $session->get('url');
			$req = [

	              'uuid' => $uuid,
	              //'uuid'=>"851144a2-7d23-4a0a-9996-0e8378ff6e5e",

	        ];

	         $curl = curl_init();
		      curl_setopt_array($curl, [
		      CURLOPT_URL => $url.'/'.'payment-request/get-by-uuid',
		      CURLOPT_RETURNTRANSFER => true,
		      CURLOPT_ENCODING => "",
		      CURLOPT_MAXREDIRS => 10,
		      CURLOPT_TIMEOUT => 30,
		      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		      CURLOPT_CUSTOMREQUEST => "POST",
		      CURLOPT_POSTFIELDS => json_encode($req),
		      // CURLOPT_POSTFIELDS => "{\"parameters\":[{\"name\":\"name\",\"value\":\"$name\"},{\"name\":\"phone\",\"value\":\"$phone\"}],\"template_name\":\"$template_name\",\"broadcast_name\":\"$broadcast_name\"}",
		      CURLOPT_HTTPHEADER => [
		        "Authorization: Bearer".$api_key,
		       "Content-Type: application/json"
		      ],
		    ]);

	        $response = curl_exec($curl);
	        $err = curl_error($curl);
	        $data_convert = json_decode($response);


			$posted = array();
			$filter = JFilterInput::getInstance();
			foreach($_REQUEST as $key => $value)
			{
				$key = $filter->clean($key);
				$value = JRequest::getString($key);
				$posted[$key]=$value;
			}
			
			// if (!isset($posted['custom'])) {
			// 	die("No 'custom' field passed!\n");
			// }
			
			//We load the parameters of the plugin in $this->payment_params and the order data based on the order_id coming from the payment platform
			//$order_id = (int)$posted['custom'];
			
			$order_id  = $session->get('order_id');
			$dbOrder = $this->getOrder($order_id);
			$this->loadPaymentParams($dbOrder);
			if(empty($this->payment_params))
				die("Error loading payment params!");
			$this->loadOrderData($dbOrder);

			// if (floatval($posted['amount1']) < round($dbOrder->order_full_price, 8)) {
			// 	$this->errorAndDie('Payment amount is less than order total!');
			// }
			
			$status = $data_convert->status;

			print "AdaPayments transaction status: ".$status."\n";
			if (isset($data_convert->status) && $data_convert->status == 'confirmed' || isset($data_convert->status) && $data_convert->status== 'pending')  {
	 
				  JFactory::getApplication()->redirect('index.php?option=com_hikashop&ctrl=checkout&task=after_end&order_id='.$order_id . $this->url_itemid);

			} else{


	            //JFactory::getApplication()->redirect('index.php?option=com_hikashop&ctrl=checkout');

	            $message = array();
				//Order and payment successfully made - no downloadable items
				$message['payment_canceled'] 	= "Your Payment not initiate yet please do the Payment , Go back to Previous tab for completing the payment";
				JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_hikashop&ctrl=checkout&task=after_end'),$message['payment_canceled']);

			}
	   }catch(Error $e){

            echo 'Something went Wrong: ',  $e->getMessage(), "\n";
       }	

	}
}
