<?php
/*
Plugin Name: CHG - COTI ADA Pay - ADA Donations
Description: This WordPress plugin will allow you to create unique customized ADA Payment donation widgets on WordPress posts or pages and accept donations. Creates custom ADA Payment donation widgets.
Author: CarlhenryGlobal
Version: 1.1.0
Author URI: http://carlhenryglobal.com/
*/

/*
if (!class_exists("WP_Donations")) {
	class WP_Donations {
		public function __construct() {
		
		}
		
		//DB Functions
		public function define_db_tables() {
			
		}
	}
}

if (class_exists("WP_Donations")) {
    global $ob_WP_Donations;
	$ob_WP_Donations = new WP_Donations();
}
*/

// echo "<pre>";
// print_r('ok');
// die;

global $cpDonations_table;
global $cpDonations_plugin_db_version;
global $wpdb;
$cpDonations_table = $wpdb->prefix . 'cp_donations';
$cpDonations_plugin_db_version = '1.3';

register_activation_hook( __FILE__,  'cpDonations_install' );

function cpDonations_install() {
  global $wpdb;
  global $cpDonations_table;

  if ( $wpdb->get_var( "show tables like '$cpDonations_table'" ) != $cpDonations_table ) {
			
	$sql = "CREATE TABLE $cpDonations_table (".
		"Id INT NOT NULL AUTO_INCREMENT, ".
		"name VARCHAR( 100 ) NOT NULL, ".
		"slug VARCHAR( 100 ) NOT NULL, ".
		"description TEXT, ".
		"donationtype INT NOT NULL, ".
		"maxitems INT NOT NULL, ".
		"defaultdonation DECIMAL(7,2),".
		"PRIMARY KEY Id (Id) ".
		")";
	
	require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
	dbDelta( $sql );
	
	add_option( "cpDonations_plugin_db_version", $cpDonations_plugin_db_version );	
  }
  add_option("cpDonations_Business_Name", "Enter Api Key");
}

function cpDonations_options() {
	if (!get_option('cpDonations_returnUrl')) {
		add_option('cpDonations_returnUrl', "");	
	}
	if (!get_option('cpDonations_buttonStyle')) {
		add_option('cpDonations_buttonStyle', "default");	
	}
	if (!get_option('cpDonations_restrictToPagePost')) {
		add_option('cpDonations_restrictToPagePost', "true");	
	}
}
add_action('plugins_loaded', 'cpDonations_options');

//Add Admin Styles
function cpDonation_admin_style() {
	wp_register_style('cpDonation-admin-style', WP_PLUGIN_URL.'/ada-donations/admin/styles/style.css');
	wp_enqueue_style('cpDonation-admin-style');
}

// Create Admin Panel
function add_cpDonations_menu()
{
	add_menu_page(__('ADA Donations','menu-cpDonations'), __('ADA Donations','menu-cpDonations'), 'manage_options', 'cpDonations-admin', 'showCpDonationsMenu' );
	
	// Add a submenu to the custom top-level menu:
	//add_submenu_page('cpDonations-admin', __('ADA Donations >> Add Page','menu-cpDonations'), __('Add Donation','menu-cpDonations'), 'manage_options', 'add-cpDonation', 'add_cpDonation');
	//add_submenu_page('cpDonations-admin', __('ADA Donations >> Add Page','menu-cpDonations'), __('Edit Donation','menu-cpDonations'), 'manage_options', 'edit-cpDonation', 'edit_cpDonation');
}

add_action( 'admin_menu', 'add_cpDonations_menu' );
add_action( 'admin_menu', 'cpDonation_admin_style' );

function showCpDonationsMenu()
{
	include("admin/overview.php");
}

// function add_cpDonation()
// {
// 	include("admin/add-cpDonation.php");
// }

// function edit_cpDonation()
// {
// 	include("admin/edit-cpDonation.php");
// }

function add_jquery_cpDonation() {
	wp_register_script('cp-donations', WP_PLUGIN_URL.'/ada-donations/scripts/jquery.cpDonations.js', array('jquery'));
	wp_enqueue_script('jquery');
	wp_enqueue_script('cp-donations');
}
add_action('wp_enqueue_scripts', 'add_jquery_cpDonation');

function add_styles_cpDonation() {
	wp_register_style( 'cp_donations_stylesheet', WP_PLUGIN_URL.'/ada-donations/styles/style.css');
	wp_enqueue_style('cp_donations_stylesheet');
}
add_action('wp_enqueue_scripts', 'add_styles_cpDonation');



function cpDonation_Handler($atts) {
	$atts = shortcode_atts( array( 'id' => '-1', 'key' => '-1'), $atts );
	return createCPDonationForm($atts['id'], $atts['key']);
}
add_shortcode('cpDonation', 'cpDonation_Handler');

//Gutenburg Block code
function cp_donation_block_init() {
	// Register our block editor script.
	wp_register_script(
		'cp-donation-block',
		plugins_url( 'scripts/cp-donation-block.js', __FILE__ ),
		array( 'wp-blocks', 'wp-element', 'wp-components', 'wp-editor' )
	);
	// Register our block, and explicitly define the attributes we accept.
	register_block_type( 'hcg/cp-donation-block', array(
		'attributes'      => array(
			'key' => array(
				'type' => 'string',
			),
		),
		'editor_script'   => 'cp-donation-block', // The script name we gave in the wp_register_script() call.
		'render_callback' => 'cpDonation_Handler',
	) );
}
//add_action( 'init', 'cp_donation_block_init' );



// Taken from Google XML Sitemaps from Arne Brachhold
function add_cpDonations_plugin_links($links, $file) {	
	if ( $file == plugin_basename(__FILE__) ) {			
		$links[] = '' . __('Donate', 'cpDonations') . '</a>';			
	}
	return $links;
}
	
//Add the extra links on the plugin page
add_filter('plugin_row_meta', 'add_cpDonations_plugin_links', 10, 2);
add_action( 'init', 'cpd_code_button' );

function cpd_code_button() {
    add_filter( "mce_external_plugins", "cpd_code_add_button" );
    add_filter( 'mce_buttons', 'cpd_code_register_button' );
}
function cpd_code_add_button( $plugin_array ) {
    $plugin_array['cpdbutton'] = $dir = plugins_url( 'scripts/shortcode.js', __FILE__ );
    return $plugin_array;
}
function cpd_code_register_button( $buttons ) {
    array_push( $buttons, 'cpdselector' );
    return $buttons;
}

function register_cp_donation_widget() {
	require_once('lib/widget-class.php');
	register_widget( 'CP_Donation_Widget' );
}
add_action( 'widgets_init', 'register_cp_donation_widget' );
?>